from random import randint
import pprint # Pour pretty print ;-)
from typing import List, Dict

def gen_password(length: int, chars: str) -> str:
    """ Génère un mot de passe aléatoire.
    @param length la longueur désirée
    @param chars les caractères autorisés
    @return: le mot de passe généré
    """
    password = ""
    for _ in range(length):
        random_index: int = randint(0, len(chars) - 1)
        password += chars[random_index]
    return password

PASSWORD_LENGTH = 14
PASSWORD_CHARS = "".join(chr(code) for code in range(32, 127))

# On part de la liste de contacts déjà normalisée
contacts: List[Dict] = [
    {"nom": "TEHEI", "prenom": "Mehiti"},
    {"nom": "HAUATA", "prenom": "Manu"},
    {"nom": "WEI", "prenom": "Lin"},
    {"nom": "DURAND", "prenom": "Pierre"}
]

# Parcourir chaque contact pour l"enrichir
for contact in contacts:
    # Générer le login ; exemple: "TEHEI Mehiti" -> "m.tehe"
    premiere_lettre_prenom: str = contact["prenom"][0].lower()
    quatre_premieres_lettres_nom: str = contact["nom"][:4].lower()
    login: str = premiere_lettre_prenom + "." + quatre_premieres_lettres_nom
    contact["login"] = login

    # Générer le mot de passe
    contact["mot_de_passe"] = gen_password(PASSWORD_LENGTH, PASSWORD_CHARS)

# Afficher le résultat pour vérifier
pprint.pprint(contacts)
